echo off
cd /D "%~dp0"

echo.
echo Checking for Administrator privileges...
echo.
openfiles > NUL 2>&1
if %errorlevel%==0 (
    echo Administrator privileges found, Proceeding...
    goto :check_64bitness
) else (
    echo You are not running as Administrator...
    echo.
    echo Please right-click and select ^'Run as Administrator^' and try again...
    echo.
    echo Press any key to exit...
    pause 
    exit
)

echo.
echo Checking for 64Bit architecture...
echo.
:check_64bitness
set _os_bitness=64
 if %PROCESSOR_ARCHITECTURE% == x86 (
   if not defined PROCESSOR_ARCHITEW6432 set _os_bitness=32)
echo Operating System is %_os_bitness% bit
if %_os_bitness% == 32 (
     echo.
     echo SdO Server requires Windows 10 Pro 64Bit or Windows Server 2016 ...
     echo.
     echo Press any key to exit...
     pause
     exit
) 

echo.
echo Checking for suitable Windows version...
echo.
set  WinProductName=""
for /f "skip=1 tokens=3,*" %%a in ('reg.exe query "HKLM\software\Microsoft\Windows NT\CurrentVersion" /v "ProductName"') do set "WinProductName=%%a %%b"
echo WinProductName = %WinProductName%

echo.%WinProductName | findstr /C:"Windows 10 pro" 1>nul
if errorlevel 1 (
  set SuitableWindows=""
) ELSE (
  set SuitableWindows="Windows 10 pro"
)
if %SuitableWindows% == "Windows 10 pro" goto :WindowsProductNameOK

echo.%WinProductName | findstr /C:"Windows Server 2016" 1>nul
if errorlevel 1 (
  set SuitableWindows=""
) ELSE (
  set SuitableWindows="Windows Server 2016"
)
if %SuitableWindows% == "Windows Server 2016" goto :WindowsProductNameOK 

     echo.
     echo SdO Server requires Windows 10 Pro 64Bit or Windows Server 2016 ...
     echo.
     echo Press any key to exit...
     pause
     exit
:WindowsProductNameOK

echo.
echo Windows version is OK: %SuitableWindows%
echo. 

:create_share

mkdir .\SdOAgentLANDist
mkdir .\SdOAgentWANDist
xcopy "%CD%\SdOAgentSetup\*" ".\SdOAgentLANDist"
xcopy "%CD%\SdOAgentSetup\*" ".\SdOAgentWANDist"

Net Share SdO-Agent-LAN-Dist /delete
 
reg delete hklm\software\ServiceDeskOptimiser /v "SdOAgentLANDistFolder" /f
reg delete hklm\software\ServiceDeskOptimiser /v "SdOAgentWANDistFolder" /f
reg add hklm\software\ServiceDeskOptimiser /v "SdOAgentLANDistFolder" /t REG_SZ /d "%CD%\SdOAgentLANDist"
reg add hklm\software\ServiceDeskOptimiser /v "SdOAgentWANDistFolder" /t REG_SZ /d "%CD%\SdOAgentWANDist"
echo The agent LAN software can be found in this folder: "%CD%\SdOAgentLANDist" folder 
echo The agent WAN software can be found in this folder: "%CD%\SdOAgentWANDist" folder

rem set /p CreateShareYN=Do you wish to create a network share to distribute the agent software (Y/[N])?
rem if /i "%CreateShareYN%" neq "Y" goto install_server

:lookup_end 

Net Share SdO-Agent-LAN-Dist="%CD%\SdOAgentLANDist" /grant:Everyone,READ || goto share_create_error

echo The SdO-Agent-LAN-Dist network share has been created for folder: "%CD%\SdOAgentLANDist"
goto install_server

:share_create_error

echo The SdO-Agent-LAN-Dist network share could NOT be created. If needed, a network share will have to be created manually for folder: "%CD%\SdOAgentLANDist"
pause

echo.
echo Installing %SuitableWindows%
echo. 

:install_server
SdOServerSetup.exe